package com.xunyi.game.player.client.dto;

import com.xunyi.game.core.ClientType;
import com.xunyi.game.core.FCMStatus;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 *
 */
@Data
public class PlayerLoginInput {

    /**
     * 玩家OpenID
     */
    @NotBlank
    private String playerOpenId;

    /**
     * 防沉迷控制
     */
    private FCMStatus fcmStatus;

    /**
     * 客户端IP
     */
    private String clientIp;

    /**
     * 游戏ID
     */
    @NotBlank
    private String gameId;

    /**
     * 服务器ID
     */
    @NotNull
    private Integer serverId;

    /**
     * 客户端类型
     */
    private ClientType clientType;


    /**
     * 扩展信息
     */
    private Map<String, Object> metadata;

}
