package com.xunyi.game.player.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.game.player.client.dto.PlayerLoginInput;
import com.xunyi.game.player.client.dto.PlayerLoginWebOutput;
import com.xunyi.game.player.client.dto.PlayerOutput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Service
@FeignClient("game-player")
public interface GamePlayerClient {

    @PostMapping("/api/app-gateway/{appId}/login")
    ReturnResult<PlayerLoginWebOutput> login(
            @PathVariable("appId") String appId,
            @RequestBody PlayerLoginInput input
    );


    @GetMapping("/api/app-gateway/{appId}/player")
    ReturnResult<PlayerOutput> player(
            @PathVariable("appId") String appId,
            @RequestParam("gameId") String gameId,
            @RequestParam("openId") String openId
    );
}
