package com.xunyi.game.pay.client.dto;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.xunyi.game.pay.data.*;
import lombok.Data;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;

import java.math.BigDecimal;
import java.time.Instant;

@Data
public class OrderOutput {


    private String id;

    /**
     * 归属应用ID
     */
    private String appId;

    private String orderNo;

    private String subject;

    private TargetPlayer player;

    /**
     * 订单类型
     */
    private OrderType type;

    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            include = JsonTypeInfo.As.EXTERNAL_PROPERTY,
            property = "type",
            visible = true
    )
    @JsonSubTypes({
            @JsonSubTypes.Type(value = PackageOrderBody.class, name = "body"),
    })
    private OrderBody body;


    //金额
    private BigDecimal amount;
    //支付订单号
    private String paymentOrderId;

    //支付状态
    private PaymentState paymentState;
    //支付信息
    private Payment payment;

    //支付金额
    private BigDecimal paidAmount;


    private Instant createdAt;
}
