/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.core;

import java.time.LocalDate;
import java.time.Period;

public enum FCMStatus {
    ADULT,
    UNDER_18,
    UNDER_16,
    UNDER_8,
    NONE;


    public static FCMStatus valueOfBirthdate(LocalDate birthdate) {
        if (birthdate == null) {
            return NONE;
        }
        int age = Period.between(birthdate, LocalDate.now()).getYears();
        if (age < 8) {
            return UNDER_8;
        }
        if (age < 16) {
            return UNDER_16;
        }
        if (age < 18) {
            return UNDER_18;
        }
        return ADULT;
    }
}

