package com.xunyi.game.common.web.configuration;

import com.xunyi.game.common.MessageErrors;
import org.beast.data.message.MessageErrorOwner;
import org.beast.web.bind.MessageErrorOwnerProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class GameAppAutoConfiguration {

    @Bean
    public MessageErrorOwnerProvider applicationErrorOwnerProvider() {
        return new MessageErrorOwnerProvider() {
            public MessageErrorOwner ofCode(String code) throws Throwable {
                return MessageErrors.valueOf(code);
            }
        };
    }
}
