package game

import com.google.common.base.Joiner
import com.xunyi.game.channel.callable.data.FCMStatus
import com.xunyi.game.channel.script.support.Hashing
import com.xunyi.game.channel.script.support.Now
import com.xunyi.game.channel.script.support.Sort



api("LoginWeb") { input ->

    def isadault
    switch (input.fcmStatus) {
        case FCMStatus.ADULT:
            isadault = "0"; break
        case FCMStatus.UNDER_18:
        case FCMStatus.UNDER_16:
        case FCMStatus.UNDER_8:
            isadault = "1"; break
        default:
            isadault = "1"; break
    }
    def params = [
        openkey : "openkey",
        pfkey: "pfkey",
        isadault: isadault,
        openid: input.openId,
        pf: "912",
        arg:"arg=weiduan",
        ts: String.valueOf(Now.getEpochSecond()),
    ]

    String content = join(params, Sort.ASC, {entry ->
        return entry.key + "=" + entry.value
    }, '&')
    def ori = Joiner.on("&").join(['GET', URLEncoder.encode('/login/', "utf-8"), URLEncoder.encode(content, "utf-8")])
    //key: IcpZkZl9K0LJdX55&
    def sign = Hashing.hmacSha1(ori, context.loginKey)
    params.put("sig", sign)
    params.put("serverid", input.serverId)
    return ok {
        url("http://zzsgweb.siweikongjian.net/index.html", params)
    }
}


