package game

import com.google.common.base.Strings
import com.xunyi.game.channel.callable.data.*
import com.xunyi.game.channel.callable.exception.*
import com.xunyi.game.channel.script.support.*



api("LoginWeb") { input ->
    def cm
    switch (input.fcmStatus) {
        case FCMStatus.ADULT:
            cm = "1"; break
        case FCMStatus.UNDER_18:
        case FCMStatus.UNDER_16:
        case FCMStatus.UNDER_8:
            cm = "0"; break
        default:
            cm = "2"; break
    }
    def clienttype
    switch (input.webType) {
        case LoginWebType.BOX:
            clienttype = "2"; break;
        case LoginWebType.MICRO:
            clienttype = "3";  break;
        case LoginWebType.WEB:
            clienttype = "1";  break;
        default: throw new IllegalStateException()
    }
    def params = [
        username: input.openId,
        serverid: input.serverId,
        agent: "xunlei",
        clienttype: clienttype,
        isvip: "0",
        viplevel: "0",
        viptype: "0",
        paytype: "0",
        isgoldvip: "0",
        goldlevel: "0",
        isAnnualMember: "0",
        time: Now.getEpochSecond(),
        cm: cm,
    ]

    def ori1 = "${params.agent}${params.clienttype}${params.cm}${params.goldlevel}${params.isvip}${params.isgoldvip}${params.paytype}${context.loginKey}${params.serverid}${params.time}${params.username}${params.viplevel}${params.viptype}"

    def token1 = Hashing.md5(ori1)
    params.put("token", token1)
    def token2 = Hashing.md5(
            "${params.isAnnualMember}${params.time}${context.loginKey}"
    )
    params.put("token2", token2)
    return ok {
        url(Placeholder.replace(context.loginUrl, input), params)
    }
}

api("GetRoles") { input ->
    //查询角色
    return errorWithMessage(GameErrorCode.UNKNOWN, "")

}

api("Recharge") { input ->
    if (Strings.isNullOrEmpty(context.fixedRate)) {
        throw new IllegalArgumentException();
    }
    def params = [
        orderid: input.orderNo as Object,
        user: input.openId,
        gold: input.money * Long.parseLong(context.fixedRate),
        money: input.money,
        time: Now.getEpochSecond(),
    ]
    def ori = "${params.orderid}${params.user}${params.gold}${params.money}${params.time}${context.rechargeKey}"
    String sign = Hashing.md5(ori)
    params.put("sign", sign)
    params.put("server", input.serverId)
    //params.put("ip")
    params.put("ext", input.attach);
    if (input.roleId != null) {
        params.put("roleid", input.roleId)
    }


    String response = Http.get(Placeholder.replace(context.rechargeUrl, input), params)
    if (response ==  "1" || response == "2") {
        return ok();
    } else if (response == "-1") {
        //提交参数不全
        return errorWithMessage(GameErrorCode.ERR_CHANNEL_EXCEPTION, response);
    } else if (response == "-2") {
        //验证失败
        return errorWithMessage(GameErrorCode.ERR_CHANNEL_EXCEPTION, response);
    } else if (response == "-3") {
        return errorWithMessage(GameErrorCode.ERR_ROLES_NO_CREATED, response)
    } else if (response == "-4") {
        //请求超时
        return errorWithMessage(GameErrorCode.ERR_CHANNEL_EXCEPTION, response)
    } else if (response == "-5") {
        //服务器编号错误
        return errorWithMessage(GameErrorCode.ERR_SERVER_ID_INVALID, response)
    } else if (response == "-6") {
        //渠道方IP限制
        return errorWithMessage(GameErrorCode.ERR_CHANNEL_EXCEPTION, response)
    }
    return errorWithMessage(GameErrorCode.UNKNOWN, response)
}
