package game

import com.google.common.base.Strings
import com.xunyi.game.channel.callable.exception.GameErrorCode
import com.xunyi.game.channel.script.support.Hashing
import com.xunyi.game.channel.script.support.Http
import com.xunyi.game.channel.script.support.Now
import com.xunyi.game.channel.script.support.Placeholder

import static com.xunyi.game.channel.script.support.Utils.generateSecurityData

/**
 * 街机三国
 */

api('LoginWeb') { input ->

    // 此处登录需要的是用户id，不是加密账号
    if (input.metadata == null || input.metadata.get("userId") == null) {
        throw new IllegalArgumentException();
    }
    def userId = input.metadata.get("userId")      // 用户id

    byte[] secData = generateSecurityData(userId, context.password, input.clientIp, context.privateKey,
            context.publicKey, input.serverId, context.sign)
    def userinfo = Base64.getEncoder().encodeToString(secData);
    def params = [
            userinfo: userinfo,
            svrflag : "11",
            serverid: input.serverId
    ]
    def requestUrl = Placeholder.replace(context.loginUrl, input)
    String response = Http.get(requestUrl, params)
    String result = response.substring(response.indexOf('=') + 1, response.indexOf(';'));
    def retLoginUrl
    if (Integer.parseInt(result) == 0) {
        retLoginUrl = response.substring(response.lastIndexOf(";url=") + 5);
        // if( Lists.newArrayList("000089", "000057", "000085").contains(gameid)){
        if (retLoginUrl.contains("xunlei.com")) {
            retLoginUrl.replace("xunlei.com", "niuxyx.com");
        }
    }
    return ok { retLoginUrl }
}


api('Recharge') { input ->
    if (Strings.isNullOrEmpty(context.fixedRate)) {
        throw new IllegalArgumentException();
    }
    def params = [
            user   : input.openId,
            orderid: input.orderNo,
            money  : String.valueOf(input.money),
            gold   : input.money * Integer.parseInt(context.fixedRate),
            time   : Now.getEpochSecond() as String,
            server : input.serverId,
            ip     : "127.0.0.1",
            ext    : "",
    ]

    String ori = params.orderid + params.user + params.gold + params.money + params.time + context.rechargeKey
    params.put("sign", Hashing.md5(ori).toLowerCase())
    String response = Http.get(Placeholder.replace(context.rechargeUrl, input), params)

    // 1 成功, 2 订单号重复，相同订单已成功充值
    if ("1".equals(response) || "2".equals(response)) {
        return ok()              // 充值成功
    } else {
        return errorWithMessage(GameErrorCode.UNKNOWN, response)
    }

}
