package game

import com.google.common.base.Strings
import com.xunyi.game.channel.callable.data.*
import com.xunyi.game.channel.callable.exception.*
import com.xunyi.game.channel.script.support.*

import java.time.Instant


api('LoginWeb') { input ->
    def params = [
            gameId: input.gameId,
            timestamp: Now.getEpochSecond(),

            openId: input.openId,
            serverId: input.serverId,
            fcmStatus: input.fcmStatus,
            webType: input.webType,

    ]
    params.put("signType", "MD5")
    String ori = join(params, Sort.ASC, { entry ->
        return entry.key + "=" + String.valueOf(entry.value)
    }, '&') + context.key

    params.put("sign", Hashing.md5(ori))
    return ok{
        url(context.loginUrl, params)
    }
}

api('GetRoles') { input ->
    def uri = context.getRolesUrl
    def params = [
            gameId: input.gameId,
            timestamp: Now.getEpochSecond(),

            openId: input.openId,
            serverId: input.serverId,
    ]
    params.put("signType", "MD5")
    String ori = join(params, Sort.ASC, { entry ->
        return entry.key + "=" + String.valueOf(entry.value)
    }, '&') + context.key
    params.put("sign", Hashing.md5(ori))
    String response = Http.get(uri, params)
    def ret = parseJson(response)
    def code = ret['code']
    if (code == 0) {
        def data = ret.data
        return ok(data.collect({ item ->
            role {
                id = item.id
                level = item.level
                name = item.name
                createdAt = Instant.ofEpochSecond(item.createdAt)
            }
        }))
    } else if (code == -2) {
        return GameErrorCode.ERR_USER_NO_CREATED.withChannel(response)
    } else if (code == -3) {
        return GameErrorCode.ERR_SERVER_ID_INVALID.withChannel(response)
    } else {
        return errorWithMessage(GameErrorCode.UNKNOWN, response)
    }
}

api('Recharge') { input ->
    def uri = context.rechargeUrl
    def params = [
            gameId: input.gameId,
            timestamp: Now.getEpochSecond(),

            orderNo: input.orderNo,
            openId: input.openId,
            serverId: input.serverId,
            money: input.money,
    ]
    if (input.roleId) {
        params.put("roleId", input.roleId)
    }
    if (input.outOrderNo) {
        params.put('outOrderNo', input.outOrderNo)
    }
    if (input.attach) {
        params.put('attach', input.attach)
    }
    params.put("signType", "MD5")
    String ori = join(params, Sort.ASC, { entry ->
        return entry.key + "=" + String.valueOf(entry.value)
    }, '&') + context.rechargeKey
    params.put("sign", Hashing.md5(ori))
    String response = Http.get(uri, params)
    if (response == "0" || response == "1") {
        return ok();
    } else if (response == "-2") {
        //用户未创建
        return GameErrorCode.ERR_USER_NO_CREATED.withChannel(response)
    } else if (response == "-3") {
        //区服无效
        return GameErrorCode.ERR_SERVER_ID_INVALID.withChannel(response)
    } else {
        return errorWithMessage(GameErrorCode.UNKNOWN, response)
    }
}
