package game


import com.google.common.base.Strings
import com.google.common.io.BaseEncoding
import com.xunyi.game.channel.callable.data.FCMStatus
import com.xunyi.game.channel.callable.data.LoginWebType
import com.xunyi.game.channel.callable.exception.GameErrorCode
import com.xunyi.game.channel.script.support.Hashing
import com.xunyi.game.channel.script.support.Http
import com.xunyi.game.channel.script.support.Now

/**
 * 裁决战歌
 */

api('LoginWeb') { input ->

    def indulge              //防沉迷标记：填y视为开启防沉迷；不填或者填n均视关闭为防沉迷
    switch (input.fcmStatus) {
        case FCMStatus.ADULT:
            indulge = "n"; break
        case FCMStatus.UNDER_18:
        case FCMStatus.UNDER_16:
        case FCMStatus.UNDER_8:
            indulge = "y"; break
        default:
            indulge = "n"; break
    }
    def isclient              // int 不填或者填0均视为浏览器登录；填1视为登录器登录
    switch (input.webType) {
        case LoginWebType.BOX:
            isclient = 1; break;
        case LoginWebType.MICRO:
            isclient = 0; break;
        default:
            isclient = 0; break;
    }
    def authParams = [
            pid    : context.platform,     // 平台id  "xunyi"
            sid    : input.serverId,      // 区服id
            uid    : input.openId,        // 游戏账户id
            indulge: indulge,             // 防沉迷标记：填y视为开启防沉迷；不填或者填n均视关闭为防沉迷
            exts   : "",                  // 扩展参数，不是必要项
            time   : Now.getEpochSecond(),  // 从平台跳转的时间
    ]
    String ori = "pid=" + authParams.pid + "&sid=" + authParams.sid + "&uid=" + authParams.uid + "&time=" + authParams.time + "&indulge=" + authParams.indulge + "&exts=" + authParams.exts
    System.out.println(ori)

    def auth = BaseEncoding.base64().encode(ori.getBytes());
    def params = [
            isclient: isclient,
            auth    : auth
    ]
    params.put("sign", Hashing.md5(auth + context.loginKey))
    return ok {
        url(context.loginUrl, params)
    }
}


api('Recharge') { input ->
    if (Strings.isNullOrEmpty(context.fixedRate)) {
        throw new IllegalArgumentException();
    }
    def params = [
            orderid  : input.orderNo,      // 订单号
            partnerid: context.partnerid,  // 合作商编号 "60"
            gameid   : context.gameid,     // 游戏编号 ”72“
            sid      : input.serverId,     // 合作商游戏服务器编号，1服为1，2服为2
            userid   : input.openId,       // 玩家用户id，传输时urlencode编码 (userId 和 userName 以userName 这个为准(进游戏是哪个就是哪个)//userId 和 userName 以userName 这个为准(进游戏是哪个就是哪个))
            username : input.openId,       // 玩家用户名，传输时urlencode编码
            actorid  : "",                 // 玩家角色id，一般情况下传空字符串
            actorname: "",                 // 玩家角色名，一般情况下传空字符串
            money    : String.valueOf(input.money),  // 充值金额(人名币)，以此值兑换游戏币。测试请使用小数额。（单位为元，精确到小数点后两位）
            time     : Now.getEpochSecond(),   // 发起请求时间，Unix时间戳
    ]

    // 签名验证，md5后的结果小写 md5(gameid+ partnerid+sid+urlencode(userid)+urlencode(username)+orderid + money + time+ api_key)
    def encodeUserId = Hashing.urlEncode(params.userid, "UTF-8");
    def encodeuserName = Hashing.urlEncode(params.username, "UTF-8");
    String ori = params.gameid + params.partnerid + params.sid + encodeUserId + encodeuserName + params.orderid + params.money + params.time + context.rechargeKey
    params.put("sign", Hashing.md5(ori).toLowerCase())
    def uri = context.rechargeUrl
    String response = Http.get(uri, params)
    // 1 成功, -2 订单号重复，相同订单已成功充值
    if (response == "1") {
        return ok()              // 充值成功
    } else if (response == "2") {
        return errorWithMessage(GameErrorCode.ERR_PARAMS_WRONG, response);     // 参数不全
    } else if(response == "4"){
        return errorWithMessage(GameErrorCode.ERROR_NOT_WHITE_IP, response);     // 访问IP不在白名单
    } else if (response == "15") {
        return errorWithMessage(GameErrorCode.ERR_CONNECTION_TIMEOUT, response);  // 请求超时
    } else if (response == "-2") {
        return errorWithMessage(GameErrorCode.ERR_ORDER_ID_REPEAT, response);   //订单重复
    } else if (response == "-3") {
        return errorWithMessage(GameErrorCode.ERROR_SIGN_INVALID, response);    // 签名错误
    } else {
        return errorWithMessage(GameErrorCode.UNKNOWN, response)
    }

}
