/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.channel.script.support;

import com.xunlei.server.common.exception.AESException;
import com.xunlei.server.common.util.AESUtil;
import com.xunlei.server.common.util.CommonUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static byte[] generateSecurityData(String username, String password, String ip, String privateKey, String publicKey, String serverid, String sign) {
        byte[] userPac = new byte[96];
        byte[] cooperateServerPac = new byte[110];
        try {
            Object key1 = AESUtil.makeKey((byte[])Utils.getKeyByte(privateKey));
            Object key2 = AESUtil.makeKey((byte[])Utils.getKeyByte(publicKey));
            Arrays.fill(userPac, (byte)32);
            Arrays.fill(cooperateServerPac, (byte)32);
            Utils.copyBytes(sign.getBytes(), userPac, 0);
            Utils.copyBytes(username.getBytes(), userPac, 4);
            Utils.copyBytes(password.getBytes(), userPac, 36);
            byte[] serverIdByte = CommonUtil.intToByteArray((int)Integer.parseInt(serverid));
            Utils.copyBytes(serverIdByte, userPac, 68);
            String[] ipStrings = ip.split("\\.");
            byte[] ipBytes = new byte[ipStrings.length];
            for (int i = 0; i < ipStrings.length; ++i) {
                try {
                    int temp = Integer.parseInt(ipStrings[i]);
                    ipBytes[i] = (byte)temp;
                    continue;
                }
                catch (Exception e) {
                    ipBytes[i] = 0;
                }
            }
            Utils.copyBytes(ipBytes, userPac, 88);
            Utils.copyBytes(AESUtil.encrypt((byte[])userPac, (Object)key1), cooperateServerPac, 0);
            Utils.copyBytes(Utils.formatServerid(serverid), cooperateServerPac, 100);
            return AESUtil.encrypt((byte[])cooperateServerPac, (Object)key2);
        }
        catch (AESException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private static void copyBytes(byte[] src, byte[] desc, int descStart) {
        for (int j = 0; j < src.length; ++j) {
            desc[descStart + j] = src[j];
        }
    }

    private static byte[] formatServerid(String serverid) {
        byte[] server = serverid.getBytes();
        byte[] serverPac = new byte[10];
        Arrays.fill(serverPac, (byte)32);
        Utils.copyBytes(server, serverPac, serverPac.length - server.length);
        return serverPac;
    }

    private static byte[] getKeyByte(String keyValue) {
        if (StringUtils.isEmpty((CharSequence)keyValue)) {
            return null;
        }
        String[] keyArr = keyValue.split(",");
        byte[] keyByte = new byte[keyArr.length];
        for (int i = 0; i < keyArr.length; ++i) {
            keyByte[i] = Byte.parseByte(keyArr[i]);
        }
        return keyByte;
    }
}

