/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.channel.script.callable;

import com.xunyi.game.channel.callable.GameCallable;
import com.xunyi.game.channel.callable.exception.GameCallException;
import com.xunyi.game.channel.callable.exception.GameErrorCode;
import com.xunyi.game.channel.script.GameResultReturn;
import com.xunyi.game.channel.script.exception.HttpException;
import groovy.lang.Closure;

public class AbstractScriptCallable<I, O>
implements GameCallable<I, O> {
    private String name;
    protected Closure<GameResultReturn<O>> closure;

    protected AbstractScriptCallable(Closure<GameResultReturn<O>> closure) {
        this.closure = closure;
        this.name = this.getClass().getSimpleName();
    }

    public O execute(I input) throws GameCallException {
        try {
            GameResultReturn ret = (GameResultReturn)this.closure.call(input);
            if (ret.hasError()) {
                String message = ret.getError().name();
                throw new GameCallException(this.name, input, ret.getError(), ret.getChannelMessage());
            }
            return (O)ret.getData();
        }
        catch (HttpException e) {
            throw new GameCallException(this.name, input, GameErrorCode.ERR_HTTP_EXCEPTION, e.getMessage());
        }
    }

    @Override
    public O call(I input) throws GameCallException {
        return this.execute(input);
    }
}

