/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.channel.script;

import com.google.common.collect.Maps;
import com.xunyi.game.channel.callable.GameCallable;
import com.xunyi.game.channel.callable.data.Role;
import com.xunyi.game.channel.script.GameResultReturn;
import com.xunyi.game.channel.script.callable.GetRolesScriptCallable;
import com.xunyi.game.channel.script.callable.LoginWebScriptCallable;
import com.xunyi.game.channel.script.callable.RechargeScriptCallable;
import groovy.lang.Closure;
import java.util.List;
import java.util.Map;

public class GameScript {
    private Map<String, GameCallable> callableMap = Maps.newHashMap();

    public GameScript(Map<String, Closure> callableMap) {
        callableMap.forEach(this::put);
    }

    private void put(String name, Closure closure) {
        switch (name) {
            case "LoginWeb": {
                this.callableMap.put(name, new LoginWebScriptCallable((Closure<GameResultReturn<String>>)closure));
                break;
            }
            case "GetRoles": {
                this.callableMap.put(name, new GetRolesScriptCallable((Closure<GameResultReturn<List<Role>>>)closure));
                break;
            }
            case "Recharge": {
                this.callableMap.put(name, new RechargeScriptCallable((Closure<GameResultReturn<Void>>)closure));
            }
        }
    }

    public GameCallable callable(String name) {
        GameCallable callable = this.callableMap.get(name);
        if (callable == null) {
            throw new UnsupportedOperationException("name:" + name + " unsupported");
        }
        return callable;
    }
}

