/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.channel.script;

import com.xunyi.game.channel.callable.exception.GameErrorCode;
import java.io.Serializable;

public class GameResultReturn<T>
implements Serializable {
    private T data;
    private GameErrorCode error;
    private String channelMessage;

    private GameResultReturn(GameErrorCode error, T data) {
        this.error = error;
        this.data = data;
    }

    public static <T> GameResultReturn ok(T data) {
        return new GameResultReturn<T>(null, data);
    }

    public static <T> GameResultReturn error(GameErrorCode error) {
        return new GameResultReturn<Object>(error, null);
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String toString() {
        return "GameResultReturn(data=" + this.getData() + ", error=" + this.getError() + ", channelMessage=" + this.getChannelMessage() + ")";
    }

    public T getData() {
        return this.data;
    }

    public GameErrorCode getError() {
        return this.error;
    }

    public String getChannelMessage() {
        return this.channelMessage;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setError(GameErrorCode error) {
        this.error = error;
    }

    public void setChannelMessage(String channelMessage) {
        this.channelMessage = channelMessage;
    }
}

