/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.channel.script;

import com.google.common.base.Joiner;
import com.xunyi.game.channel.callable.data.Role;
import com.xunyi.game.channel.callable.exception.GameErrorCode;
import com.xunyi.game.channel.script.GameResultReturn;
import com.xunyi.game.channel.script.support.Sort;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DSLMethods {
    public static GameResultReturn ok(Object data) {
        if (data instanceof Closure) {
            data = ((Closure)data).call();
        }
        return GameResultReturn.ok(data);
    }

    public static GameResultReturn errorWithMessage(GameErrorCode error, String message) {
        GameResultReturn ret = DSLMethods.error(error);
        ret.setChannelMessage(message);
        return ret;
    }

    public static GameResultReturn error(GameErrorCode error) {
        return GameResultReturn.error(error);
    }

    public static String join(Map<String, Object> params, final Sort sort, final Closure<Object> value, String separator) {
        List entries = params.entrySet().stream().sorted(new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                String k1 = o1.getKey();
                String k2 = o2.getKey();
                return sort == Sort.ASC ? k1.compareTo(k2) : k2.compareTo(k1);
            }
        }).collect(Collectors.toList());
        List items = entries.stream().map(new Function<Map.Entry<String, Object>, String>(){

            @Override
            public String apply(Map.Entry<String, Object> entry) {
                return String.valueOf(value.call(entry));
            }
        }).collect(Collectors.toList());
        return Joiner.on((String)separator).join(items);
    }

    public static Role role(Closure closure) {
        Role role = new Role();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)role);
        closure.call();
        return role;
    }

    public static Object parseJson(String text) {
        JsonSlurper slurper = new JsonSlurper();
        return slurper.parseText(text);
    }

    public static String url(String uri, Map<String, Object> params) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        QueryStringEncoder encoder = new QueryStringEncoder(decoder.path());
        decoder.parameters().forEach((key, values) -> {
            String value = "";
            if (values.size() > 0) {
                value = (String)values.get(0);
            }
            encoder.addParam(key, value);
        });
        params.forEach((key, value) -> {
            String valueString = value instanceof String ? (String)value : String.valueOf(value);
            encoder.addParam(key, valueString);
        });
        return encoder.toString();
    }
}

