package game

import com.xunyi.game.channel.script.support.Hashing
import com.xunyi.game.channel.script.support.Http
import com.xunyi.game.channel.script.support.Now
import com.xunyi.game.channel.script.support.Sort

import java.time.Instant


api('LoginWeb') { input ->
    def params = [
        openId: input.openId,
        serverId: input.serverId,
        fcmStatus: input.fcmStatus,
        webType: input.webType,
        time: Now.getEpochSecond()
    ]
    String ori = join(params, Sort.ASC, { entry ->
        return entry.key + "=" + String.valueOf(entry.value)
    }, '&') + context.accountKey
    params.put("sign", Hashing.md5(ori))
    return ok{
        url("http://www.baidu.com", params)
    }
}

api('GetRoles') { input ->
    def uri = "http://www.baidu.com/roles"
    def params = [
            openId: input.openId,
            serverId: input.serverId,
            time: Now.getEpochSecond()
    ]
    String ori = join(params, Sort.ASC, { entry ->
        return entry.key + "=" + String.valueOf(entry.value)
    }, '&') + context.accountKey
    params.put("sign", Hashing.md5(ori))
    String response = Http.get(uri, params)
    def ret = parseJson(response)
    def code = ret['code']
    if (code == 0) {
        def data = ret.data
        return ok(data.collect({ item ->
            role {
                id = item.id
                level = item.level
                name = item.name
                createdAt = Instant.ofEpochSecond(item.createdAt)
            }
        }))
    } else if (code == -2) {
        return GameErrorCode.ERR_USER_NO_CREATED.withChannel(response)
    } else if (code == -3) {
        return GameErrorCode.ERR_SERVER_ID_INVALID.withChannel(response)
    } else {
        return GameErrorCode.UNKNOWN.withChannel(response)
    }
}

api('Recharge') { input ->
    def uri = "http://www.baidu.com/recharge"
    def params = [
            orderNo: input.orderNo,
            openId: input.openId,
            serverId: input.serverId,
            money: input.money,
            time: Now.getEpochSecond()
    ]
    if (input.roleId) {
        params.put("roleId", input.roleId)
    }
    if (input.outOrderNo) {
        params.put('outOrderNo', input.outOrderNo)
    }
    if (input.attach) {
        params.put('attach', input.attach)
    }
    String ori = join(params, Sort.ASC, { entry ->
        return entry.key + "=" + String.valueOf(entry.value)
    }, '&') + context.rechargeKey
    params.put("sign", Hashing.md5(ori))
    String response = Http.get(uri, params)
    if (response == "0" || response == "1") {
        return ok();
    } else if (response == "-2") {
        //用户未创建
        return GameErrorCode.ERR_USER_NO_CREATED.withChannel(response)
    } else if (response == "-3") {
        //区服无效
        return GameErrorCode.ERR_SERVER_ID_INVALID.withChannel(response)
    } else {
        return GameErrorCode.UNKNOWN.withChannel(response)
    }
}
