/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.channel.script.support;

import com.google.common.base.Charsets;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.function.BiFunction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Http {
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;

    public static String get(String url, Map<String, Object> params) throws IOException {
        params.replaceAll((BiFunction<String, Object, Object>)new BiFunction<String, Object, String>(){

            @Override
            public String apply(String s, Object value) {
                return String.valueOf(value);
            }
        });
        Map<String, Object> stringParams = params;
        return Http.get(url, stringParams, Charsets.UTF_8.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> params, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            conn = Http.getConnect(Http.buildQuery(url, params), "GET", null);
            conn.setRequestProperty("Accept", "text/plain,text/xml,text/javascript,text/html");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + charset);
            rsp = Http.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnect(URL url, String method, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection httpsConn = null;
            httpsConn = (HttpsURLConnection)url.openConnection();
            httpsConn.setSSLSocketFactory(socketFactory);
            httpsConn.setHostnameVerifier(verifier);
            httpsConn = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
            conn = httpsConn;
        } else {
            conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("User-Agent", "game-gateway");
        return conn;
    }

    private static URL buildQuery(String uri, Map<String, String> params) throws IOException {
        QueryStringEncoder stringEncoder = new QueryStringEncoder(uri);
        params.forEach((arg_0, arg_1) -> ((QueryStringEncoder)stringEncoder).addParam(arg_0, arg_1));
        return new URL(stringEncoder.toString());
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = Http.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return IOUtils.toString((InputStream)conn.getInputStream(), (String)charset);
        }
        String msg = IOUtils.toString((InputStream)es, (String)charset);
        if (StringUtils.isEmpty((CharSequence)msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static String getResponseCharset(String ctype) {
        String charset = Charsets.UTF_8.toString();
        if (!StringUtils.isEmpty((CharSequence)ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty((CharSequence)pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    static {
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            socketFactory = ctx.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return false;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

