package com.xunyi.game.gateway.client;

import com.xunyi.game.gateway.client.dto.ChannelGetRoles;
import com.xunyi.game.gateway.client.dto.ChannelLoginWeb;
import com.xunyi.game.gateway.client.dto.GameConfig;
import com.xunyi.game.gateway.client.dto.Role;
import com.xunyi.beast.data.message.ReturnResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient("game-channel-gateway")
public interface GameChannelGatewayClient {

    @GetMapping("/api/game-configs")
    ReturnResult<List<GameConfig>> getGameConfigByAppGame(
            @RequestParam(name = "appId") String appId,
            @RequestParam(name = "gameId") String gameId
    );

    @PostMapping("/api/game-configs")
    ReturnResult<GameConfig> insertGameConfig(
            @RequestBody GameConfig input);

    @PutMapping("/api/game-configs/{id}")
    ReturnResult updateGameConfigById(
            @PathVariable("id") String id,
            @RequestBody GameConfig input
    );

    @PostMapping("/api/channel-gateway/games/{gameId}/login-web")
    ReturnResult<String> loginWeb(
            @PathVariable("gameId") String gameId,
            @RequestBody ChannelLoginWeb loginWeb
    );

    @GetMapping("/api/channel-gateway/games/{gameId}/get-roles")
    ReturnResult<List<Role>> getRoles(
            @PathVariable("gameId") String gameId,
            @SpringQueryMap ChannelGetRoles getRoles
    );
}
