/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.game.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.game.client.dto.Game;
import com.xunyi.game.client.dto.GameQueryInput;
import com.xunyi.game.client.vo.GameCoin;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Service
@FeignClient(value="game-center")
public interface GameCenterClient {
    @GetMapping(value={"/api/games"})
    public ReturnResult<List<Game>> queryGames(@SpringQueryMap GameQueryInput var1);

    @GetMapping(value={"/api/games/{id}"})
    public ReturnResult<Game> getGameById(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/games"})
    public ReturnResult<Game> createGame(@RequestBody Game var1);

    @PutMapping(value={"/api/games/{id}"})
    public ReturnResult<Game> updateGameById(@PathVariable(value="id") String var1, @RequestBody Game var2);

    @PatchMapping(value={"/api/games/{id}"})
    public ReturnResult<Game> patchGameById(@PathVariable(value="id") String var1, @RequestBody Game var2);

    @PostMapping(value={"/api/games/{id}/coin"})
    public ReturnResult upsertCoin(@PathVariable(value="id") String var1, @Validated @RequestBody GameCoin var2);
}

