package com.xunyi.game.client.dto;

import com.xunyi.game.client.vo.GameClientType;
import com.xunyi.game.client.vo.GameCoin;
import com.xunyi.game.client.vo.GameType;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

@Getter @Setter
public class Game {

    /**
     * 游戏ID
     */
    private String id;

    /**
     * 游戏编号
     */
    private String no;

    /**
     * 游戏名称
     */
    private String name;

    /**
     * 游戏分类
     */
    private GameType type;

    /**
     * 游戏客户端类型
     */
    private GameClientType clientType;
    /**
     * 游戏icon
     */
    private String icon;

    /**
     * 游戏一句话概述
     */
    private String outline;

    /**
     * 游戏介绍
     */
    private String introduction;

    /**
     * 游戏币
     */
    private GameCoin coin;
    /**
     * 游戏状态
     */
    private Status status;

    private Instant updatedAt;

    private Instant createdAt;


    public enum Status {
        //开发中
        DEVELOPMENT,
        //维护中
        MAINTENANCE,
        //生产环境
        PRODUCTION,
        //游戏已停服
        STOPPED,
    }
}
