package com.xunyi.game.client;

import com.xunyi.game.client.dto.Game;
import com.xunyi.game.client.dto.GameQueryInput;
import com.xunyi.game.client.vo.GameCoin;
import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.ReturnResult;
import feign.QueryMap;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Service
@FeignClient("game-center")
public interface GameCenterClient {

    @GetMapping("/api/games")
    ReturnResult<List<Game>> queryGames(@SpringQueryMap GameQueryInput input);

    @GetMapping("/api/games/{id}")
    ReturnResult<Game> getGameById(@PathVariable("id") String id);

    @PostMapping("/api/games")
    ReturnResult<Game> createGame(@RequestBody Game input);

    @PutMapping("/api/games/{id}")
    ReturnResult<String> updateGameById(
            @PathVariable("id") String id,
            @RequestBody Game input
    );

    @PatchMapping("/api/games/{id}")
    ReturnResult<String> patchGameById(
            @PathVariable("id") String id,
            @RequestBody Game input
    );

    @PostMapping("/api/games/{id}/coin")
    ReturnResult upsertCoin(
            @PathVariable("id") String id,
            @Validated @RequestBody GameCoin input
    );
}
