/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.communi.message.domain;

import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.PropertyPlaceholderHelper;

@Document(collection="template")
public class Template {
    @Indexed(unique=true)
    private String code;
    private String content;
    private Set<String> args;
    private Instant createdAt;
    private static PropertyPlaceholderHelper PLACEHOLDER_HELPER = new PropertyPlaceholderHelper("${", "}");

    public Set<String> differenceArgs(Set<String> args) {
        if (this.args == null) {
            return Sets.newHashSet(args);
        }
        return Sets.difference(this.args, args);
    }

    public String resolveValue(Map<String, String> args) {
        return PLACEHOLDER_HELPER.replacePlaceholders(this.content, args::get);
    }

    public String getCode() {
        return this.code;
    }

    public String getContent() {
        return this.content;
    }

    public Set<String> getArgs() {
        return this.args;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setArgs(Set<String> args) {
        this.args = args;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }
}

