/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.communi.message.domain;

import com.xunyi.communi.message.domain.bo.CreateMessage;
import com.xunyi.communi.message.domain.vo.SendState;
import java.time.Instant;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="message")
public class Message {
    @Id
    private String id;
    @Indexed
    private String appId;
    private String outId;
    @Indexed
    private String mobile;
    private Instant sendAt;
    private Instant sentAt;
    private Instant receiveAt;
    @Indexed
    private String templateCode;
    private Map<String, String> templateParams;
    private String content;
    private String signName;
    @Indexed
    private String channelId;
    private SendState sendState;
    private String reason;
    @Indexed
    private Instant createdAt;

    public static Message create(CreateMessage createMessage) {
        String templateCode = createMessage.getTemplateCode();
        String signName = createMessage.getSignName();
        Message message = new Message();
        message.setAppId(createMessage.getAppId());
        message.setOutId(createMessage.getOutId());
        message.setMobile(createMessage.getMobile());
        message.setTemplateCode(templateCode);
        message.setTemplateParams(createMessage.getTemplateParams());
        message.setSendAt(null);
        message.setReceiveAt(null);
        message.setSignName(signName);
        message.setSendState(SendState.PENDING);
        message.setReason(null);
        message.setCreatedAt(Instant.now());
        return message;
    }

    public String getId() {
        return this.id;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getOutId() {
        return this.outId;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Instant getSendAt() {
        return this.sendAt;
    }

    public Instant getSentAt() {
        return this.sentAt;
    }

    public Instant getReceiveAt() {
        return this.receiveAt;
    }

    public String getTemplateCode() {
        return this.templateCode;
    }

    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    public String getContent() {
        return this.content;
    }

    public String getSignName() {
        return this.signName;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public SendState getSendState() {
        return this.sendState;
    }

    public String getReason() {
        return this.reason;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setOutId(String outId) {
        this.outId = outId;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setSendAt(Instant sendAt) {
        this.sendAt = sendAt;
    }

    public void setSentAt(Instant sentAt) {
        this.sentAt = sentAt;
    }

    public void setReceiveAt(Instant receiveAt) {
        this.receiveAt = receiveAt;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public void setTemplateParams(Map<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setSendState(SendState sendState) {
        this.sendState = sendState;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$outId = this.getOutId();
        String other$outId = other.getOutId();
        if (this$outId == null ? other$outId != null : !this$outId.equals(other$outId)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        Instant this$sendAt = this.getSendAt();
        Instant other$sendAt = other.getSendAt();
        if (this$sendAt == null ? other$sendAt != null : !((Object)this$sendAt).equals(other$sendAt)) {
            return false;
        }
        Instant this$sentAt = this.getSentAt();
        Instant other$sentAt = other.getSentAt();
        if (this$sentAt == null ? other$sentAt != null : !((Object)this$sentAt).equals(other$sentAt)) {
            return false;
        }
        Instant this$receiveAt = this.getReceiveAt();
        Instant other$receiveAt = other.getReceiveAt();
        if (this$receiveAt == null ? other$receiveAt != null : !((Object)this$receiveAt).equals(other$receiveAt)) {
            return false;
        }
        String this$templateCode = this.getTemplateCode();
        String other$templateCode = other.getTemplateCode();
        if (this$templateCode == null ? other$templateCode != null : !this$templateCode.equals(other$templateCode)) {
            return false;
        }
        Map<String, String> this$templateParams = this.getTemplateParams();
        Map<String, String> other$templateParams = other.getTemplateParams();
        if (this$templateParams == null ? other$templateParams != null : !((Object)this$templateParams).equals(other$templateParams)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$signName = this.getSignName();
        String other$signName = other.getSignName();
        if (this$signName == null ? other$signName != null : !this$signName.equals(other$signName)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        SendState this$sendState = this.getSendState();
        SendState other$sendState = other.getSendState();
        if (this$sendState == null ? other$sendState != null : !((Object)((Object)this$sendState)).equals((Object)other$sendState)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $outId = this.getOutId();
        result = result * 59 + ($outId == null ? 43 : $outId.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        Instant $sendAt = this.getSendAt();
        result = result * 59 + ($sendAt == null ? 43 : ((Object)$sendAt).hashCode());
        Instant $sentAt = this.getSentAt();
        result = result * 59 + ($sentAt == null ? 43 : ((Object)$sentAt).hashCode());
        Instant $receiveAt = this.getReceiveAt();
        result = result * 59 + ($receiveAt == null ? 43 : ((Object)$receiveAt).hashCode());
        String $templateCode = this.getTemplateCode();
        result = result * 59 + ($templateCode == null ? 43 : $templateCode.hashCode());
        Map<String, String> $templateParams = this.getTemplateParams();
        result = result * 59 + ($templateParams == null ? 43 : ((Object)$templateParams).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $signName = this.getSignName();
        result = result * 59 + ($signName == null ? 43 : $signName.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        SendState $sendState = this.getSendState();
        result = result * 59 + ($sendState == null ? 43 : ((Object)((Object)$sendState)).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Message(id=" + this.getId() + ", appId=" + this.getAppId() + ", outId=" + this.getOutId() + ", mobile=" + this.getMobile() + ", sendAt=" + this.getSendAt() + ", sentAt=" + this.getSentAt() + ", receiveAt=" + this.getReceiveAt() + ", templateCode=" + this.getTemplateCode() + ", templateParams=" + this.getTemplateParams() + ", content=" + this.getContent() + ", signName=" + this.getSignName() + ", channelId=" + this.getChannelId() + ", sendState=" + this.getSendState() + ", reason=" + this.getReason() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

