package com.xunyi.communi.client.maixun;

import com.xunyi.communi.client.AbstractClientFactory;
import com.xunyi.communi.client.ChannelType;
import lombok.Getter;
import lombok.Setter;

public class MaiXunClientFactory extends AbstractClientFactory<MaiXunClient, MaiXunClientFactory.Config> {


    public MaiXunClientFactory() {
        super(Config.class);
    }

    @Override
    public MaiXunClient newClient(Config config) {
        return new MaiXunClient(
            config.getTarget(),
            config.getUserId(),
            config.getAccount(),
            config.getPassword()
        );
    }

    @Override
    public ChannelType type() {
        return ChannelType.MAIXUN;
    }

    @Getter @Setter
    public static class Config {
        private String target;
        private String userId;
        private String account;
        private String password;
    }
}
