package com.xunyi.communi.client.maixun;

import com.xunyi.communi.client.CallException;
import com.xunyi.communi.client.maixun.dto.DirectSend;
import feign.*;
import feign.jaxb.JAXBContextFactory;
import feign.jaxb.JAXBDecoder;

import java.util.List;

public class MaiXunClient {

    private String userId;
    private String account;
    private String password;


    private MaiXunHttpClient httpClient;

    public MaiXunClient(String target, String userId, String account, String password) {
        JAXBContextFactory jaxbFactory = new JAXBContextFactory.Builder().build();
        this.httpClient = Feign.builder()
//                .client(new OkHttpClient())
            .requestInterceptor(new RequestInterceptor() {
                @Override
                public void apply(RequestTemplate template) {

                    template.url();
                }
            })
            .decoder(new JAXBDecoder.Builder().withNamespaceAware(false).withJAXBContextFactory(jaxbFactory).build())
//            .errorDecoder(new ErrorDecoder() {
//                @Override
//                public Exception decode(String methodKey, Response response) {
//                    try {
//                        String message = IOUtils.toString(response.body().asInputStream(), StandardCharsets.UTF_8);
//                        return new FeignException.errorStatus(methodKey, response);
//                        return new FeignException.InternalServerError(message, null, message.getBytes());
//                    } catch (IOException e) {
//                        return e;
//                    }
//                }
//            })
            .target(MaiXunHttpClient.class, target);
        this.userId = userId;
        this.account = account;
        this.password = password;
    }

    public void send(List<String> mobiles, String content) throws CallException {

        StringBuilder phoneBuilder = new StringBuilder();
        for (String mobile : mobiles) {
            phoneBuilder.append(mobile);
            phoneBuilder.append(";");
        }

        DirectSend directSend = this.httpClient.directSend(
                userId,
                account,
                password,
                phoneBuilder.toString(),
                content,
                1
        );
        if (directSend.hasError()) {
            throw new CallException(directSend.getRetCode(), directSend.getMessage());
        }
    }

}
