package com.xunyi.communi.client.aliyun;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunyi.communi.client.AbstractClientFactory;
import com.xunyi.communi.client.ChannelType;
import lombok.Getter;
import lombok.Setter;

public class AliYunClientFactory extends AbstractClientFactory<AliYunClient, AliYunClientFactory.Config> {

    private ObjectMapper objectMapper;

    public AliYunClientFactory() {
        super(Config.class);
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public AliYunClient newClient(Config config) {
        DefaultProfile profile = DefaultProfile.getProfile("default", config.accessKeyId, config.secret);
        IAcsClient client = new DefaultAcsClient(profile);
        return new AliYunClient(client, objectMapper);
    }

    @Override
    public ChannelType type() {
        return ChannelType.ALIYUN;
    }

    @Getter @Setter
    public static class Config {

        private String accessKeyId;

        private String secret;
    }
}
