package com.xunyi.communi.client.aliyun;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunyi.communi.client.CallException;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

@Slf4j
public class AliYunClient {

    private IAcsClient client;
    private ObjectMapper objectMapper;
    public AliYunClient(IAcsClient client, ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
    }

    public void send(String mobile, String signName, String templateCode) throws CallException {
        this.send(mobile, signName, templateCode, null, null);
    }
    public void send(String mobile, String signName, String templateCode, Map<String, String> params) throws CallException {
        this.send(mobile, signName, templateCode, params, null);
    }
    public void send(String mobile, String signName, String templateCode, Map<String, String> params, String outId) throws CallException {
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain("dysmsapi.aliyuncs.com");
        request.setVersion("2017-05-25");
        request.setAction("SendSms");
        request.putQueryParameter("RegionId", "default");
        request.putQueryParameter("PhoneNumbers", mobile);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateCode);
        try {
            if (params != null) {
                request.putQueryParameter("TemplateParam", this.objectMapper.writeValueAsString(params));
            }
        } catch (JsonProcessingException e) {
            throw new CallException("client", "json处理异常", e);
        }
        if (outId != null) {
            request.putQueryParameter("outId", outId);
        }
        try {
            CommonResponse response = client.getCommonResponse(request);
            log.info("response data:{}", response.getData());
        } catch (ClientException e) {
            throw new CallException(e.getErrCode(), e.getMessage(), e);
        }
    }
}
