package com.xunyi.communi.client;

import org.springframework.beans.BeanUtils;

/**
 *
 */
public abstract class AbstractClientFactory<T, C> implements ClientFactory<T, C>{
    private Class<C> configClass;

    public AbstractClientFactory(Class<C> configClass) {
        this.configClass = configClass;
    }


    @Override
    public Class<C> getConfigClass() {
        return this.configClass;
    }

    @Override
    public C newConfig() {
        return BeanUtils.instantiateClass(this.configClass);
    }
}
