/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.communi.client.maixun;

import com.xunyi.communi.client.CallException;
import com.xunyi.communi.client.maixun.MaiXunHttpClient;
import com.xunyi.communi.client.maixun.dto.DirectSend;
import feign.Feign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.codec.Decoder;
import feign.jaxb.JAXBContextFactory;
import feign.jaxb.JAXBDecoder;
import java.util.List;

public class MaiXunClient {
    private String userId;
    private String account;
    private String password;
    private MaiXunHttpClient httpClient;

    public MaiXunClient(String target, String userId, String account, String password) {
        JAXBContextFactory jaxbFactory = new JAXBContextFactory.Builder().build();
        this.httpClient = (MaiXunHttpClient)Feign.builder().requestInterceptor(new RequestInterceptor(){

            public void apply(RequestTemplate template) {
                template.url();
            }
        }).decoder((Decoder)new JAXBDecoder.Builder().withNamespaceAware(false).withJAXBContextFactory(jaxbFactory).build()).target(MaiXunHttpClient.class, target);
        this.userId = userId;
        this.account = account;
        this.password = password;
    }

    public void send(List<String> mobiles, String content) throws CallException {
        StringBuilder phoneBuilder = new StringBuilder();
        for (String mobile : mobiles) {
            phoneBuilder.append(mobile);
            phoneBuilder.append(";");
        }
        DirectSend directSend = this.httpClient.directSend(this.userId, this.account, this.password, phoneBuilder.toString(), content, 1);
        if (directSend.hasError()) {
            throw new CallException(directSend.getRetCode(), directSend.getMessage());
        }
    }
}

