package com.xunyi.beast.hand.protocol.ws;

import lombok.Getter;

import java.util.Map;

/**
 * 协议:
 * [type]空格[target]\r\n         -> 请求头
 * [头部字段]:[值]\r\n            -> headers 请求头部
 * \r\n
 * [body]                         ->
 */
@Getter
public class WSMessage {

    private WSType type;

    private String target;

    private Map<String, String> headers;

    private byte[] body;


    public WSMessage(WSType type, String target, Map<String, String> headers, byte[] body) {
        this.type = type;
        this.target = target;
        this.headers = headers;
        this.body = body;
    }

}
