package com.xunyi.beast.hand.protocol.ws;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;

import java.util.List;

public class TargetLineParser {
//    private static final int DEFAULT_MAX_LENGTH = 1024;
    private String target;

    private List<String> items = null;

    public TargetLineParser(String target) {
        this.target = target;

    }

    public List<String> items() {
        if (items == null) {
            items = Lists.newArrayList();
            Iterable<String> iterable = Splitter.on("/").split(this.target);
            iterable.forEach((item) -> {
                items.add(item);
            });
        }
        return items;
    }

    public String index(int index) {
        if (this.items().size() > index) {
            return this.items().get(index);
        } else {
            return null;
        }

    }

    public WSTargetType type() {
        return WSTargetType.valueOf(this.index(0));
    }

    public String target() {
        return this.index(1);
    }
}
