package com.xunyi.beast.hand.config.client;

import com.xunyi.beast.hand.config.client.dto.PipeDefinitionOutput;
import com.xunyi.beast.hand.config.client.dto.WSRouteDefinitionOutput;
import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.beast.hand.core.Env;
import com.xunyi.beast.hand.core.Hostname;
import com.xunyi.beast.hand.core.definition.HttpRouteDefinition;
import com.xunyi.beast.hand.core.definition.ShuntDefinition;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient("beast-hand-config")
public interface BeastHandConfigClient {

    @GetMapping("/api/pipes")
    ReturnResult<List<PipeDefinitionOutput>> listPipeBy();

    @GetMapping("/api/ws-routes")
    ReturnResult<List<WSRouteDefinitionOutput>> listWSRouteDefinitionBy();


    @GetMapping("/api/hostnames")
    ReturnResult<List<Hostname>> getHostnames();

    @GetMapping("/api/shunts?open=true")
    ReturnResult<List<ShuntDefinition>> getShunts();



    @GetMapping("/api/http-routes?open=true")
    ReturnResult<List<HttpRouteDefinition>> getRoutes(@RequestParam("env") List<Env> envs);

}
