package com.xunyi.beast.web.servlet.error;

import brave.Span;
import brave.Tracer;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.springframework.web.context.request.WebRequest;

import java.util.Map;

public class TraceErrorAttributesProvider implements ErrorAttributesProvider{

    private Tracer tracer;

    public TraceErrorAttributesProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Map<String, Object> apply(WebRequest webRequest) {

        Span span = tracer.currentSpan();
        String traceId = span.context().traceIdString();
//        TraceContext context = currentTraceContext.get();

//        String traceId = context.traceIdString();
        return Map.of("traceId", traceId);
    }
}
