package com.xunyi.beast.web.servlet.error;


import com.google.common.collect.Maps;
import com.xunyi.beast.data.message.*;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 没显性拦截  没view的 异常处理
 */
@Controller
@RequestMapping("${server.error.path:${error.path:/error}}")
public class BeastErrorController extends AbstractErrorController {

    public BeastErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        this(errorAttributes, errorProperties, Collections.emptyList());
    }
    public BeastErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties,
                                List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
        Assert.notNull(errorProperties, "ErrorProperties must not be null");
    }

    @RequestMapping(produces = MediaType.TEXT_HTML_VALUE)
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = getStatus(request);
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        Map<String, Object> model = Collections
                .unmodifiableMap(getErrorAttributes(request, options));
        response.setStatus(status.value());
        ModelAndView modelAndView = resolveErrorView(request, response, status, model);
        return (modelAndView != null) ? modelAndView : new ModelAndView("error", model);
    }

    @RequestMapping
    public ResponseEntity<?> error(HttpServletRequest request) {
        HttpStatus status = getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity<>(status);
        }

        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        Map<String, Object> errorAttributes = Collections
                .unmodifiableMap(getErrorAttributes(request, options));
        String error = (String) errorAttributes.get("error");
        if (error == null) {
            if (status == HttpStatus.NOT_FOUND) {
                error = StandardErrors.NOT_FOUND.toError().getCode();
            } else {
                error = StandardErrors.SERVICE_INTERNAL_ERROR.toError().getCode();
            }
        }

//        Map<String, Object> body = Maps.newHashMap();

//        body.put("error", Map.of("code", error, "message", errorAttributes.get("message")));
//        body.put("timestamp", errorAttributes.get("timestamp"));
        ;
        return new ResponseEntity<>(
            Returns.error(new ErrorInfo(error, (String) errorAttributes.get("message"))),
            status
        );
//        return new ResponseEntity<>(body, status);
    }

    @ExceptionHandler(HttpMediaTypeNotAcceptableException.class)
    public ResponseEntity<Return<?>> mediaTypeNotAcceptable(HttpServletRequest request) {
        HttpStatus status = getStatus(request);
        return new ResponseEntity<Return<?>>(StandardErrors.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE.toReturn(), status);
    }

    @Override
    public String getErrorPath() {
        return null;
    }

}
