package com.xunyi.beast.web.servlet.error;

import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import org.apache.catalina.connector.Response;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.pattern.PathPattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class AbstractExceptionAdvice {

    private ErrorMessageSource errorMessageSource;

    public AbstractExceptionAdvice(ErrorMessageSource errorMessageSource) {
        this.errorMessageSource = errorMessageSource;
    }

    private static final String DATA_REST_PATH_PATTERN_ATTRIBUTE = "org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping.EFFECTIVE_REPOSITORY_RESOURCE_LOOKUP_PATH";
    private @Nullable
    static String getMatchingPattern(HttpServletRequest request) {
        PathPattern dataRestPathPattern = (PathPattern) request.getAttribute(DATA_REST_PATH_PATTERN_ATTRIBUTE);
        if (dataRestPathPattern != null) {
            return dataRestPathPattern.getPatternString();
        }
        return (String) request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
    }


    public ModelAndView returnErrorMessage(IError error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String message = errorMessageSource.getMessage(error);
        return returnErrorMessage(error.getCode(), message, request, response);
    }


    public ModelAndView returnErrorMessage(String code, String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, code);
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, message);
        response.sendError(Response.SC_OK);
        return new ModelAndView();
    }

    public String getRequestInfo(HttpServletRequest request) {
        String method = request.getMethod();
        String pattern = getMatchingPattern(request);
        String uri = "UNKNOWN";
        if (pattern != null) {
            //if (ignoreTrailingSlash) 忽略尾部斜杠
            if (pattern.isEmpty()) {
                uri = "ROOT";
            } else {
                uri = pattern;
            }
        }
        return "request [" + method + " " + uri +"]";
    }

}
