package com.xunyi.beast.web.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.web.converter.beast.BeastHttpMessageConverter;
import com.xunyi.beast.web.servlet.error.InnerHandlerExceptionResolver;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.servlet.Servlet;
import java.util.List;

@Configuration(proxyBeanMethods = false)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore({WebMvcAutoConfiguration.class})
public class BeastHttpMvcAutoConfiguration {

    @Configuration
    public class BeastHttpMessageConfigurer implements WebMvcConfigurer {

        private ObjectMapper objectMapper;

        public BeastHttpMessageConfigurer(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.add(new BeastHttpMessageConverter(this.objectMapper));
        }
    }
}
