package com.xunyi.beast.web.converter.beast;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.data.message.Return;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.lang.NonNull;

import java.io.IOException;
import java.lang.reflect.Type;

/**
 * 自定义协议 确保再
 */
public class BeastHttpMessageConverter extends AbstractJackson2HttpMessageConverter implements Ordered {


    public BeastHttpMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper, new MediaType("application", "beast"));
    }

    @Override
    public boolean canWrite(@NonNull Class<?> clazz, MediaType mediaType) {
        return //clazz.isAssignableFrom(Return.class) &&
                super.canWrite(clazz, mediaType);
    }

    @Override
    public boolean canRead(@NonNull Class<?> clazz, MediaType mediaType) {
        return super.canRead(clazz, mediaType);
    }


    @Override
    protected void writeInternal(@NonNull Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (object instanceof Return) {
            Return ret = (Return) object;
            IError error = ret.getError();
            HttpHeaders headers = outputMessage.getHeaders();
            String code = "OK";
            if (error != null) {
                code = error.getCode();
            }
            headers.set(BeastProtocolUtils.X_BEAST_CODE_HEADER, code);
        }
        super.writeInternal(object, type, outputMessage);

    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }

//    @Override
//    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
//        inputMessage.getHeaders();
//        return super.readInternal(clazz, inputMessage);
//    }
}
