/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.servlet.error;

import com.google.common.base.Strings;
import com.xunyi.beast.data.message.ErrorException;
import com.xunyi.beast.data.message.ErrorInfo;
import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.data.message.StandardErrors;
import com.xunyi.beast.data.message.XYError;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.util.pattern.PathPattern;

public class BeastHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(BeastHandlerExceptionResolver.class);
    private ErrorMessageSource errorMessageSource;
    private static final String DATA_REST_PATH_PATTERN_ATTRIBUTE = "org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping.EFFECTIVE_REPOSITORY_RESOURCE_LOOKUP_PATH";

    public BeastHandlerExceptionResolver(ErrorMessageSource errorMessageSource) {
        this.errorMessageSource = errorMessageSource;
        this.setWarnLogCategory(((Object)((Object)this)).getClass().getName());
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            if (ex instanceof ErrorException) {
                return this.handleError((ErrorException)ex, request, response, handler);
            }
            return this.handleException(ex, request, response, handler);
        }
        catch (Exception handlerEx) {
            this.logger.warn((Object)("Failure while trying to resolve exception [" + ex.getClass().getName() + "]"), (Throwable)handlerEx);
            return null;
        }
    }

    public ModelAndView handleError(ErrorException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("handleError:" + ex.getMessage(), (Throwable)ex);
        }
        IError error = ex.getError();
        String message = null;
        if (error instanceof ErrorInfo) {
            message = ((ErrorInfo)error).getMessage();
        }
        if (Strings.isNullOrEmpty(message)) {
            message = this.errorMessageSource.getMessage(error);
        }
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, (Object)error.getCode());
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, (Object)message);
        response.sendError(200);
        return new ModelAndView();
    }

    @Nullable
    private static String getMatchingPattern(HttpServletRequest request) {
        PathPattern dataRestPathPattern = (PathPattern)request.getAttribute(DATA_REST_PATH_PATTERN_ATTRIBUTE);
        if (dataRestPathPattern != null) {
            return dataRestPathPattern.getPatternString();
        }
        return (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
    }

    public ModelAndView handleException(Exception ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        String method = request.getMethod();
        String pattern = BeastHandlerExceptionResolver.getMatchingPattern(request);
        String uri = "UNKNOWN";
        if (pattern != null) {
            uri = pattern.isEmpty() ? "ROOT" : pattern;
        }
        log.warn("request [{} {}] resolved:[{}]", new Object[]{method, uri, ex.getMessage(), ex});
        XYError error = StandardErrors.SERVICE_INTERNAL_ERROR.toError();
        String message = this.errorMessageSource.getMessage((IError)error);
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, (Object)error.getCode());
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, (Object)message);
        response.sendError(200);
        return new ModelAndView();
    }
}

