/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.servlet.error;

import com.xunyi.beast.web.servlet.error.ErrorAttributesProvider;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class BeastErrorAttributes
implements ErrorAttributes,
HandlerExceptionResolver,
Ordered {
    public static final String ERROR_ATTRIBUTE = BeastErrorAttributes.class.getName() + ".ERROR";
    private ErrorAttributesProvider provider;

    public BeastErrorAttributes(ErrorAttributesProvider provider) {
        this.provider = provider;
    }

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, ErrorAttributeOptions options) {
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        errorAttributes.put("timestamp", OffsetDateTime.now());
        this.addStatus(errorAttributes, (RequestAttributes)webRequest);
        this.addErrorDetail(errorAttributes, webRequest);
        this.addPath(errorAttributes, (RequestAttributes)webRequest);
        errorAttributes.putAll((Map)this.provider.apply(webRequest));
        return errorAttributes;
    }

    private void addStatus(Map<String, Object> errorAttributes, RequestAttributes requestAttributes) {
        Integer status = (Integer)this.getAttribute(requestAttributes, "javax.servlet.error.status_code");
        if (status == null) {
            errorAttributes.put("status", 999);
        }
        errorAttributes.put("status", status);
    }

    private void addErrorDetail(Map<String, Object> errorAttributes, WebRequest webRequest) {
        Throwable throwable = this.getError(webRequest);
        this.addExceptionErrorMessage(errorAttributes, webRequest, throwable);
    }

    private void addExceptionErrorMessage(Map<String, Object> errorAttributes, WebRequest webRequest, @Nullable Throwable throwable) {
        String error = (String)this.getAttribute((RequestAttributes)webRequest, ServerExchangeUtils.ERROR_ATTR);
        errorAttributes.put("error", error);
        Object message = this.getAttribute((RequestAttributes)webRequest, ServerExchangeUtils.MESSAGE_ATTR);
        if (StringUtils.isEmpty(message)) {
            message = this.getAttribute((RequestAttributes)webRequest, "javax.servlet.error.message");
        }
        if (StringUtils.isEmpty(message) && throwable != null) {
            message = throwable.getMessage();
        }
        if (StringUtils.isEmpty(message)) {
            message = "No message available";
        }
        errorAttributes.put("message", message);
    }

    private void addStackTrace(Map<String, Object> errorAttributes, Throwable throwable) {
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        errorAttributes.put("trace", stackTrace.toString());
    }

    private void addPath(Map<String, Object> errorAttributes, RequestAttributes requestAttributes) {
        String path = (String)this.getAttribute(requestAttributes, "javax.servlet.error.request_uri");
        if (path != null) {
            errorAttributes.put("path", path);
        }
    }

    public Throwable getError(WebRequest webRequest) {
        Throwable exception = (Throwable)this.getAttribute((RequestAttributes)webRequest, ERROR_ATTRIBUTE);
        return exception != null ? exception : (Throwable)this.getAttribute((RequestAttributes)webRequest, "javax.servlet.error.exception");
    }

    public ModelAndView resolveException(@NonNull HttpServletRequest request, HttpServletResponse response, Object handler, @NonNull Exception ex) {
        this.storeErrorAttributes(request, ex);
        return null;
    }

    private void storeErrorAttributes(HttpServletRequest request, Exception ex) {
        request.setAttribute(ERROR_ATTRIBUTE, (Object)ex);
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

