/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.resolver;

import com.xunyi.beast.token.support.WechatUserTokenCodec;
import com.xunyi.beast.token.user.WechatUserToken;
import com.xunyi.beast.web.resolver.AbstractTokenArgumentResolver;
import com.xunyi.beast.web.resolver.WechatUserTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.MissingRequestCookieException;
import org.springframework.web.bind.ServletRequestBindingException;

public class WechatUserTokenArgumentResolver
extends AbstractTokenArgumentResolver<WechatUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(WechatUserTokenArgumentResolver.class);
    private static final String COOKIE_NAME = "wx-token";
    private final WechatUserTokenCodec codec = new WechatUserTokenCodec();

    public WechatUserTokenArgumentResolver() {
        super(COOKIE_NAME, WechatUserTokenValue.class);
    }

    @Override
    public boolean isRequired(WechatUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new MissingRequestCookieException(COOKIE_NAME, parameter);
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        WechatUserToken wechatUserToken = (WechatUserToken)this.codec.decode(tokenString);
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return wechatUserToken.getOpenId();
        }
        return wechatUserToken;
    }
}

