package com.xunyi.beast.web.servlet.error;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.springframework.web.context.request.WebRequest;

import java.util.Map;

public class TraceErrorAttributesProvider implements ErrorAttributesProvider{

    private CurrentTraceContext currentTraceContext;

    public TraceErrorAttributesProvider(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    @Override
    public Map<String, Object> apply(WebRequest webRequest) {

        TraceContext context = currentTraceContext.get();

        String traceId = context.traceIdString();
        return Map.of("traceId", traceId);
    }
}
