package com.xunyi.beast.web.servlet.error;

import com.google.common.collect.Maps;
import org.springframework.web.context.request.WebRequest;

import java.util.Map;
import java.util.function.Function;

public interface ErrorAttributesProvider extends Function<WebRequest, Map<String, Object>> {

    default ErrorAttributesProvider and(ErrorAttributesProvider other) {
        return webRequest -> {
            Map<String, Object> ret = Maps.newHashMap(other.apply(webRequest));
            ret.putAll(apply(webRequest));
            return ret;
        };
    }
}
