package com.xunyi.beast.web.resolver;

import com.xunyi.beast.token.support.WechatUserTokenCodec;
import com.xunyi.beast.token.user.WechatUserToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.MissingRequestCookieException;
import org.springframework.web.bind.ServletRequestBindingException;
import com.xunyi.beast.web.WebUtils;
@Slf4j
public class WechatUserTokenArgumentResolver extends AbstractTokenArgumentResolver<WechatUserTokenValue> {

    private static final String COOKIE_NAME = WebUtils.COOKIE_WX_USER_TOKEN;
    private final WechatUserTokenCodec codec = new WechatUserTokenCodec();

    public WechatUserTokenArgumentResolver() {
        super(COOKIE_NAME, WechatUserTokenValue.class);
    }

    @Override
    public boolean isRequired(WechatUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new MissingRequestCookieException(COOKIE_NAME, parameter);
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        WechatUserToken wechatUserToken = codec.decode(tokenString);
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return wechatUserToken.getOpenId();
        } else {
            return wechatUserToken;
        }
    }
}
