package com.xunyi.beast.web.mvc;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerTypePredicate;

import java.util.*;

public class ReturnResponseConfigurationSelector implements ImportBeanDefinitionRegistrar {


    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
        Collection<String> basePackages = Collections.singleton(ClassUtils.getPackageName(importingClassMetadata.getClassName()));
        HandlerTypePredicate handlerTypePredicate = HandlerTypePredicate.builder()
                .basePackage(basePackages.toArray(new String[0]))
                .build();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ReturnResponseBodyAdvice.class);
        builder.addPropertyValue("handlerTypePredicate", handlerTypePredicate);
        registry.registerBeanDefinition("ReturnResponseBodyAdvice", builder.getBeanDefinition());
    }

    protected Collection<String> getBasePackages(AnnotationMetadata importingClassMetadata,
                                                 @SuppressWarnings("unused") BeanDefinitionRegistry registry) {

        Map<String, Object> componentScan =
                importingClassMetadata.getAnnotationAttributes(EnableReturnResponse.class.getName());

        Set<String> basePackages = new HashSet<>();

        for (String pkg : (String[]) componentScan.get("value")) { // NOSONAR - never null
            if (StringUtils.hasText(pkg)) {
                basePackages.add(pkg);
            }
        }

        for (Class<?> clazz : (Class[]) componentScan.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName(clazz));
        }

        return basePackages;
    }
}
