package com.xunyi.beast.web.bind;

import com.xunyi.beast.data.message.IErrorOwner;

import java.util.List;

public class CompositeErrorOwnerProvider implements ErrorOwnerProvider {


    private List<ErrorOwnerProvider> providers;

    public CompositeErrorOwnerProvider(List<ErrorOwnerProvider> providers) {
        this.providers = providers;
    }

    @Override
    public IErrorOwner ofCode(String code) throws Throwable {
        for (ErrorOwnerProvider provider : providers) {
            IErrorOwner owner = provider.ofCode(code);
            if (owner != null) {
                return owner;
            }
        }
        return null;
    }
}
