package com.xunyi.beast.web.resolver;

import com.xunyi.beast.security.auth.UnauthenticatedException;
import com.xunyi.beast.token.exception.TokenException;
import com.xunyi.beast.token.support.UserTokenCodec;
import com.xunyi.beast.token.user.UserToken;
import com.xunyi.beast.web.WebUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.MissingRequestCookieException;
import org.springframework.web.bind.ServletRequestBindingException;

@Slf4j
public class UserTokenArgumentResolver extends AbstractTokenArgumentResolver<UserTokenValue>{

    private static final String COOKIE_NAME = WebUtils.COOKIE_USER_TOKEN;

    private final UserTokenCodec codec = new UserTokenCodec();

    public UserTokenArgumentResolver() {
        super(COOKIE_NAME, UserTokenValue.class);
    }

    @Override
    public boolean isRequired(UserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) {
        throw new UnauthenticatedException("token missing");
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        UserToken userToken = codec.decode(tokenString);
        try {
            userToken.verify();
        } catch (TokenException e) {
            log.warn("token invalid");
            return null;
        }
        if (Long.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return userToken.getUid();
        } else {
            return userToken;
        }
    }
}
