/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.servlet.error;

import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.data.message.IErrorOwner;
import com.xunyi.beast.data.message.StandardErrors;
import com.xunyi.beast.token.web.InvalidXYTokenException;
import com.xunyi.beast.token.web.MissingXYTokenException;
import com.xunyi.beast.web.bind.ErrorOwnerProvider;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.ModelAndView;

@RestControllerAdvice
public class ConstraintExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ConstraintExceptionAdvice.class);
    private ErrorMessageSource errorMessageSource;
    private ErrorOwnerProvider errorOwnerProvider;

    public ConstraintExceptionAdvice(ErrorOwnerProvider errorOwnerProvider, ErrorMessageSource errorMessageSource) {
        this.errorOwnerProvider = errorOwnerProvider;
        this.errorMessageSource = errorMessageSource;
    }

    protected IErrorOwner errorOfMessage(String message, IErrorOwner defaultError) {
        IErrorOwner owner = null;
        try {
            owner = this.errorOwnerProvider.ofCode(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (owner == null) {
            owner = defaultError;
        }
        return owner;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class, MethodArgumentTypeMismatchException.class})
    public ModelAndView missingRequestParameter(HttpServletRequest request, HttpServletResponse response, Exception e) throws IOException {
        String code = null;
        Object[] args = null;
        if (e instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException missingServletRequestParameterException = (MissingServletRequestParameterException)e;
            String missingParameterName = missingServletRequestParameterException.getParameterName();
            String missingParameterType = missingServletRequestParameterException.getParameterType();
            code = StandardErrors.PARAMETER_MISSING.getErrorCode();
            args = new Object[]{missingParameterType, missingParameterName};
        } else if (e instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException methodArgumentTypeMismatchException = (MethodArgumentTypeMismatchException)e;
            code = StandardErrors.PARAMETER_TYPE_MISMATCH.getErrorCode();
            String requiredType = Objects.requireNonNull(methodArgumentTypeMismatchException.getRequiredType()).getSimpleName();
            args = new Object[]{methodArgumentTypeMismatchException.getName(), requiredType};
        }
        String message = this.errorMessageSource.getMessage(code, args);
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, (Object)code);
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, (Object)message);
        response.sendError(200);
        return new ModelAndView();
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ModelAndView constraintViolationException(HttpServletRequest request, HttpServletResponse response, ConstraintViolationException cve) throws IOException {
        Set cvs = cve.getConstraintViolations();
        Iterator cvIterator = cvs.iterator();
        ConstraintViolation cs = (ConstraintViolation)cvIterator.next();
        Path propertyPath = cs.getPropertyPath();
        String message = cs.getMessage();
        log.warn("property-path: {} message: {}", (Object)propertyPath, (Object)message);
        return this.returnByMessage(message, request, response);
    }

    @ExceptionHandler(value={InvalidXYTokenException.class, MissingXYTokenException.class})
    public ModelAndView handleInvalidXYToken(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.warn("request uri:[{}] invalid XYToken ", (Object)request.getRequestURI());
        return this.returnErrorMessage((IError)StandardErrors.XYTOKEN_INVALID.toError(), request, response);
    }

    @ExceptionHandler(value={UnsatisfiedServletRequestParameterException.class})
    public ModelAndView unsatisfiedServletRequestParameterException(HttpServletRequest request, HttpServletResponse response, UnsatisfiedServletRequestParameterException e) throws IOException {
        log.warn("request uri: [{}] {}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        return this.returnErrorMessage((IError)StandardErrors.BAD_PARAMETER.toError(), request, response);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ModelAndView methodArgumentNotValidException(HttpServletRequest request, HttpServletResponse response, MethodArgumentNotValidException e) throws IOException {
        log.warn("request uri:[{}] exception:", (Object)request.getRequestURI(), (Object)e);
        return this.returnByBindingResult(e.getBindingResult(), request, response);
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public ModelAndView bindException(HttpServletRequest request, HttpServletResponse response, BindException e) throws IOException {
        log.warn("request uri:[{}] exception:", (Object)request.getRequestURI(), (Object)e);
        return this.returnByBindingResult(e.getBindingResult(), request, response);
    }

    protected ModelAndView returnByBindingResult(BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FieldError fieldError = bindingResult.getFieldError();
        assert (fieldError != null);
        String message = fieldError.getDefaultMessage();
        String field = fieldError.getField();
        log.warn("returnByBindingResult: Field field:{} Error{}", (Object)field, (Object)fieldError);
        if (message == null) {
            return this.returnErrorMessage((IError)StandardErrors.BAD_PARAMETER.toError(), request, response);
        }
        return this.returnByMessage(message, request, response);
    }

    public ModelAndView returnErrorMessage(IError error, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String message = this.errorMessageSource.getMessage(error);
        return this.returnErrorMessage(error.getCode(), message, request, response);
    }

    public ModelAndView returnByMessage(String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String code;
        IErrorOwner owner = this.errorOfMessage(message, (IErrorOwner)StandardErrors.BAD_PARAMETER);
        if (owner == StandardErrors.BAD_PARAMETER) {
            code = owner.getErrorCode();
        } else {
            code = owner.getErrorCode();
            message = this.errorMessageSource.getMessage((IError)owner.toError());
        }
        return this.returnErrorMessage(code, message, request, response);
    }

    public ModelAndView returnErrorMessage(String code, String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, (Object)code);
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, (Object)message);
        response.sendError(200);
        return new ModelAndView();
    }
}

