/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.servlet.error;

import com.google.common.collect.Maps;
import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.data.message.StandardErrors;
import com.xunyi.beast.web.bind.ErrorOwnerProvider;
import com.xunyi.beast.web.servlet.error.BeastErrorAttributes;
import com.xunyi.beast.web.servlet.error.BeastErrorController;
import com.xunyi.beast.web.servlet.error.BeastHandlerExceptionResolver;
import com.xunyi.beast.web.servlet.error.ConstraintExceptionAdvice;
import com.xunyi.beast.web.servlet.error.InnerHandlerExceptionResolver;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import feign.FeignException;
import feign.Request;
import feign.RetryableException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.HtmlUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class, ErrorMvcAutoConfiguration.class})
public class BeastErrorMvcAutoConfiguration
implements WebMvcConfigurer {
    private final ServerProperties serverProperties;

    public BeastErrorMvcAutoConfiguration(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public BeastErrorAttributes beastErrorAttributes() {
        return new BeastErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BeastErrorController basicErrorController(ErrorAttributes errorAttributes, ObjectProvider<ErrorViewResolver> errorViewResolvers) {
        return new BeastErrorController(errorAttributes, this.serverProperties.getError(), errorViewResolvers.orderedStream().collect(Collectors.toList()));
    }

    @Bean(name={"error"})
    public View beastErrorView() {
        return new ErrorView();
    }

    @Bean
    public BeastHandlerExceptionResolver beastHandlerExceptionResolver(ErrorMessageSource errorMessageSource) {
        BeastHandlerExceptionResolver resolver = new BeastHandlerExceptionResolver(errorMessageSource);
        resolver.setWarnLogCategory(((Object)((Object)resolver)).getClass().getName());
        return resolver;
    }

    @Bean
    public ConstraintExceptionAdvice constraintExceptionAdvice(ErrorOwnerProvider provider, ErrorMessageSource errorMessageSource) {
        return new ConstraintExceptionAdvice(provider, errorMessageSource);
    }

    @ConditionalOnClass(value={FeignException.class})
    @Configuration
    @RestControllerAdvice
    public static class FeignExceptionAdvice {
        private static final Logger log = LoggerFactory.getLogger(FeignExceptionAdvice.class);
        private ErrorMessageSource errorMessageSource;

        public FeignExceptionAdvice(ErrorMessageSource errorMessageSource) {
            this.errorMessageSource = errorMessageSource;
        }

        private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, FeignException e, String message) throws IOException {
            Request feignRequest = e.request();
            String httpMethod = null;
            String url = null;
            if (feignRequest != null) {
                httpMethod = String.valueOf(feignRequest.httpMethod());
                url = feignRequest.url();
            }
            log.warn("feign executing {} {} message:{}", new Object[]{httpMethod, url, message, e});
            request.setAttribute(ServerExchangeUtils.ERROR_ATTR, (Object)StandardErrors.SERVICE_INTERNAL_ERROR.getErrorCode());
            request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, (Object)this.errorMessageSource.getMessage((IError)StandardErrors.SERVICE_INTERNAL_ERROR.toError()));
            response.sendError(200);
            return new ModelAndView();
        }

        @ExceptionHandler(value={RetryableException.class})
        public ModelAndView handleRetryableException(HttpServletRequest request, HttpServletResponse response, RetryableException e) throws IOException {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return this.handleException(request, response, (FeignException)e, message);
        }

        @ExceptionHandler(value={FeignException.class})
        public ModelAndView handleFeignException(HttpServletRequest request, HttpServletResponse response, FeignException e) throws IOException {
            String message = e.getMessage();
            return this.handleException(request, response, e, message);
        }
    }

    @Configuration
    public class BeastMvcConfigurer
    implements WebMvcConfigurer {
        private ErrorMessageSource errorMessageSource;

        public BeastMvcConfigurer(ErrorMessageSource errorMessageSource) {
            this.errorMessageSource = errorMessageSource;
        }

        public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
            resolvers.remove(resolvers.size() - 1);
            resolvers.add((HandlerExceptionResolver)new InnerHandlerExceptionResolver(this.errorMessageSource));
        }
    }

    private static class ErrorView
    implements View {
        private static final Logger log = LoggerFactory.getLogger(ErrorView.class);
        private static final MediaType TEXT_HTML_UTF8 = new MediaType("text", "html", StandardCharsets.UTF_8);
        private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS ZZZ");

        private ErrorView() {
        }

        public void render(Map<String, ?> model, @NonNull HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (response.isCommitted()) {
                Object path = model.get("path");
                Object message = model.get("message");
                log.error("Cannot render error page for request [{}] and exception [{}] as the response has already been committed", path, message);
                return;
            }
            response.setContentType(TEXT_HTML_UTF8.toString());
            StringBuilder builder = new StringBuilder();
            TemporalAccessor timestamp = (TemporalAccessor)model.get("timestamp");
            String traceId = (String)model.get("traceId");
            Object message = model.get("message");
            String error = this.getError(model);
            Object trace = model.get("trace");
            builder.append("<html><body>");
            builder.append("<h1>").append(this.htmlEscape(message)).append("</h1>");
            if (error != null) {
                builder.append("<span class='subtitle'> \u9519\u8bef\u7801: ").append(error).append("</div>");
            }
            LinkedHashMap attrs = Maps.newLinkedHashMap();
            if (timestamp != null) {
                attrs.put("Timestamp", TIME_FORMATTER.format(timestamp));
            }
            if (traceId != null) {
                attrs.put("X-TraceID", traceId);
            }
            if (!attrs.isEmpty()) {
                builder.append("<ul>");
                for (Map.Entry entry : attrs.entrySet()) {
                    builder.append("<li>");
                    builder.append((String)entry.getKey()).append(": ").append(entry.getValue());
                    builder.append("</li>");
                }
                builder.append("</ul>");
            }
            if (trace != null) {
                builder.append("<div style='white-space:pre-wrap;margin-top:10px'>").append(this.htmlEscape(trace)).append("</div>");
            }
            builder.append("</body></html>");
            response.getWriter().append(builder);
        }

        private String htmlEscape(Object input) {
            return input != null ? HtmlUtils.htmlEscape((String)input.toString()) : null;
        }

        private String getError(Map<String, ?> model) {
            String error = (String)model.get("error");
            if (error != null) {
                return error;
            }
            return StandardErrors.SERVICE_INTERNAL_ERROR.getErrorCode();
        }

        public String getContentType() {
            return "text/html";
        }
    }
}

