/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.servlet.error;

import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.data.message.StandardErrors;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

public class InnerHandlerExceptionResolver
extends DefaultHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(InnerHandlerExceptionResolver.class);
    private final ErrorMessageSource errorMessageSource;

    public InnerHandlerExceptionResolver(ErrorMessageSource errorMessageSource) {
        this.errorMessageSource = errorMessageSource;
        this.setWarnLogCategory(((Object)((Object)this)).getClass().getName());
    }

    @NonNull
    protected ModelAndView handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        log.warn("request uri:[{}] method: [{}] HttpMediaTypeNotAcceptable", (Object)request.getRequestURI(), (Object)request.getMethod());
        this.applyErrorMessage((IError)StandardErrors.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE.toError(), request);
        return super.handleHttpMediaTypeNotAcceptable(ex, request, response, handler);
    }

    @NonNull
    protected ModelAndView handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        log.warn("request uri:[{}] method: [{}] supportedMediaType: [{}] HttpRequestMethodNotSupported", new Object[]{request.getRequestURI(), ex.getMethod(), ex.getSupportedMethods()});
        this.applyErrorMessage((IError)StandardErrors.HTTP_REQUEST_METHOD_NOT_SUPPORTED.toError(), request);
        return super.handleHttpRequestMethodNotSupported(ex, request, response, handler);
    }

    public void applyErrorMessage(IError error, HttpServletRequest request) {
        String message = this.errorMessageSource.getMessage(error);
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, (Object)error.getCode());
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, (Object)message);
    }
}

