/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.servlet.error;

import com.google.common.collect.Maps;
import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.StandardErrors;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class BeastErrorController
extends AbstractErrorController {
    public BeastErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        this(errorAttributes, errorProperties, Collections.emptyList());
    }

    public BeastErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
        Assert.notNull((Object)errorProperties, (String)"ErrorProperties must not be null");
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        Map model = Collections.unmodifiableMap(this.getErrorAttributes(request, options));
        response.setStatus(status.value());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        return modelAndView != null ? modelAndView : new ModelAndView("error", model);
    }

    @RequestMapping
    public ResponseEntity<?> error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity(status);
        }
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        Map errorAttributes = Collections.unmodifiableMap(this.getErrorAttributes(request, options));
        HashMap body = Maps.newHashMap();
        body.put("error", Map.of("code", errorAttributes.get("error"), "message", errorAttributes.get("message")));
        body.put("timestamp", errorAttributes.get("timestamp"));
        return new ResponseEntity((Object)body, status);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity<Return<?>> mediaTypeNotAcceptable(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        return new ResponseEntity((Object)StandardErrors.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE.toReturn(), status);
    }

    public String getErrorPath() {
        return null;
    }
}

